/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban;

import abstracktyt.easyban.commands.BanCommand;
import abstracktyt.easyban.commands.CheckBanCommand;
import abstracktyt.easyban.commands.HelpCommand;
import abstracktyt.easyban.commands.IpBanCommand;
import abstracktyt.easyban.commands.KickCommand;
import abstracktyt.easyban.commands.LinkDiscordCommand;
import abstracktyt.easyban.commands.MuteCommand;
import abstracktyt.easyban.commands.ReloadCommand;
import abstracktyt.easyban.commands.TempBanCommand;
import abstracktyt.easyban.commands.TempIpBanCommand;
import abstracktyt.easyban.commands.TempMuteCommand;
import abstracktyt.easyban.commands.UnbanCommand;
import abstracktyt.easyban.commands.UnipbanCommand;
import abstracktyt.easyban.commands.UnmuteCommand;
import abstracktyt.easyban.commands.UnwarnCommand;
import abstracktyt.easyban.commands.WarnCommand;
import abstracktyt.easyban.database.DatabaseManager;
import abstracktyt.easyban.discord.DiscordBot;
import abstracktyt.easyban.listeners.ChatListener;
import abstracktyt.easyban.listeners.ConnectionListener;
import abstracktyt.easyban.managers.ConfigManager;
import abstracktyt.easyban.managers.LinkManager;
import abstracktyt.easyban.managers.PunishmentManager;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EasyBan
extends JavaPlugin {
    private static EasyBan instance;
    private DatabaseManager databaseManager;
    private PunishmentManager punishmentManager;
    private ConfigManager configManager;
    private LinkManager linkManager;
    private DiscordBot discordBot;

    public void onEnable() {
        instance = this;
        this.getLogger().info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 EasyBan...");
        this.saveDefaultConfig();
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
            this.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d \u0444\u0430\u0439\u043b messages.yml");
        }
        this.configManager = new ConfigManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.punishmentManager = new PunishmentManager(this);
        this.linkManager = new LinkManager(this);
        if (!this.databaseManager.initialize()) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0431\u0430\u0437\u0443 \u0434\u0430\u043d\u043d\u044b\u0445! \u041f\u043b\u0430\u0433\u0438\u043d \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        if (this.getConfig().getBoolean("discord.enabled", false)) {
            this.discordBot = new DiscordBot(this);
            if (!this.discordBot.start()) {
                this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c Discord \u0431\u043e\u0442\u0430!");
            }
        }
        this.getLogger().info("EasyBan v" + this.getDescription().getVersion() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d!");
    }

    public void onDisable() {
        if (this.discordBot != null) {
            this.discordBot.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("EasyBan \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    private void registerCommands() {
        this.getCommand("ban").setExecutor((CommandExecutor)new BanCommand(this));
        this.getCommand("tempban").setExecutor((CommandExecutor)new TempBanCommand(this));
        this.getCommand("ipban").setExecutor((CommandExecutor)new IpBanCommand(this));
        this.getCommand("tempipban").setExecutor((CommandExecutor)new TempIpBanCommand(this));
        this.getCommand("unban").setExecutor((CommandExecutor)new UnbanCommand(this));
        this.getCommand("unipban").setExecutor((CommandExecutor)new UnipbanCommand(this));
        this.getCommand("mute").setExecutor((CommandExecutor)new MuteCommand(this));
        this.getCommand("tempmute").setExecutor((CommandExecutor)new TempMuteCommand(this));
        this.getCommand("unmute").setExecutor((CommandExecutor)new UnmuteCommand(this));
        this.getCommand("kick").setExecutor((CommandExecutor)new KickCommand(this));
        this.getCommand("warn").setExecutor((CommandExecutor)new WarnCommand(this));
        this.getCommand("unwarn").setExecutor((CommandExecutor)new UnwarnCommand(this));
        this.getCommand("checkban").setExecutor((CommandExecutor)new CheckBanCommand(this));
        this.getCommand("linkdiscord").setExecutor((CommandExecutor)new LinkDiscordCommand(this));
        this.getCommand("easybanreload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("easybanhelp").setExecutor((CommandExecutor)new HelpCommand(this));
    }

    public static EasyBan getInstance() {
        return instance;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public PunishmentManager getPunishmentManager() {
        return this.punishmentManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LinkManager getLinkManager() {
        return this.linkManager;
    }

    public DiscordBot getDiscordBot() {
        return this.discordBot;
    }
}

