/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.commands;

import abstracktyt.easyban.EasyBan;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BanCommand
implements CommandExecutor {
    private final EasyBan plugin;

    public BanCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!sender.hasPermission("easyban.ban")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args2.length < 2) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("usage", "/ban <player> <reason>");
            sender.sendMessage(this.plugin.getConfigManager().getMessage("insufficient-args", placeholders));
            return true;
        }
        String targetName = args2[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("player-never-joined", placeholders));
            return true;
        }
        StringBuilder reasonBuilder = new StringBuilder();
        for (int i = 1; i < args2.length; ++i) {
            reasonBuilder.append(args2[i]).append(" ");
        }
        String reason = reasonBuilder.toString().trim();
        if (reason.isEmpty()) {
            reason = this.plugin.getConfig().getString("default-reason", "Violation of server rules");
        }
        if (this.plugin.getPunishmentManager().isBanned(target.getUniqueId())) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("already-banned", placeholders));
            return true;
        }
        this.plugin.getPunishmentManager().ban(target, sender, reason, -1L);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        placeholders.put("reason", reason);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("ban-success", placeholders));
        return true;
    }
}

