/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.commands;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.models.Punishment;
import abstracktyt.easyban.utils.TimeUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CheckBanCommand
implements CommandExecutor {
    private final EasyBan plugin;

    public CheckBanCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!sender.hasPermission("easyban.checkban")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args2.length < 1) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("usage", "/checkban <player>");
            sender.sendMessage(this.plugin.getConfigManager().getMessage("insufficient-args", placeholders));
            return true;
        }
        String targetName = args2[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        Punishment ban = this.plugin.getDatabaseManager().getActiveBan(target.getUniqueId());
        if (ban == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("unban-not-banned", placeholders));
            return true;
        }
        sender.sendMessage("\u00a78\u00a7m----------\u00a7r \u00a7c\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0431\u0430\u043d\u0435 \u00a78\u00a7m----------");
        sender.sendMessage("\u00a7e\u0418\u0433\u0440\u043e\u043a: \u00a7f" + ban.getTargetName());
        sender.sendMessage("\u00a7e\u0422\u0438\u043f: \u00a7f" + ban.getType());
        sender.sendMessage("\u00a7e\u041f\u0440\u0438\u0447\u0438\u043d\u0430: \u00a7f" + ban.getReason());
        sender.sendMessage("\u00a7e\u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440: \u00a7f" + ban.getModeratorName());
        sender.sendMessage("\u00a7e\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438: \u00a7f" + TimeUtils.formatDate(ban.getTimestamp() * 1000L));
        if (ban.isPermanent()) {
            sender.sendMessage("\u00a7e\u0421\u0440\u043e\u043a: \u00a7f\u041d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
        } else {
            sender.sendMessage("\u00a7e\u0418\u0441\u0442\u0435\u043a\u0430\u0435\u0442: \u00a7f" + TimeUtils.formatDate(ban.getExpires() * 1000L));
            long remaining = ban.getExpires() - TimeUtils.currentTimeSeconds();
            sender.sendMessage("\u00a7e\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: \u00a7f" + TimeUtils.formatTime(remaining));
        }
        sender.sendMessage("\u00a78\u00a7m----------------------------------------");
        return true;
    }
}

