/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.commands;

import abstracktyt.easyban.EasyBan;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class IpBanCommand
implements CommandExecutor {
    private final EasyBan plugin;

    public IpBanCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!sender.hasPermission("easyban.ipban")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args2.length < 2) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("usage", "/ipban <player> <reason>");
            sender.sendMessage(this.plugin.getConfigManager().getMessage("insufficient-args", placeholders));
            return true;
        }
        String targetName = args2[0];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("player-not-found", placeholders));
            return true;
        }
        if (target.getAddress() == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + "\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c IP \u0430\u0434\u0440\u0435\u0441 \u0438\u0433\u0440\u043e\u043a\u0430!");
            return true;
        }
        String ip = target.getAddress().getAddress().getHostAddress();
        StringBuilder reasonBuilder = new StringBuilder();
        for (int i = 1; i < args2.length; ++i) {
            reasonBuilder.append(args2[i]).append(" ");
        }
        String reason = reasonBuilder.toString().trim();
        if (reason.isEmpty()) {
            reason = this.plugin.getConfig().getString("default-reason", "Violation of server rules");
        }
        this.plugin.getPunishmentManager().ipban(ip, (OfflinePlayer)target, sender, reason, -1L);
        return true;
    }
}

