/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.commands;

import abstracktyt.easyban.EasyBan;
import java.awt.Color;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class UnbanCommand
implements CommandExecutor {
    private final EasyBan plugin;

    public UnbanCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!sender.hasPermission("easyban.unban")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args2.length < 1) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("usage", "/unban <player>");
            sender.sendMessage(this.plugin.getConfigManager().getMessage("insufficient-args", placeholders));
            return true;
        }
        String targetName = args2[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!this.plugin.getPunishmentManager().isBanned(target.getUniqueId())) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("unban-not-banned", placeholders));
            return true;
        }
        this.plugin.getDatabaseManager().removePunishment(target.getUniqueId(), "BAN");
        this.plugin.getDatabaseManager().removePunishment(target.getUniqueId(), "TEMPBAN");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("unban-success", placeholders));
        if (this.plugin.getDiscordBot() != null) {
            HashMap<String, String> logFields = new HashMap<String, String>();
            logFields.put("\ud83d\udd28 \u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", sender.getName());
            logFields.put("\ud83d\udc64 \u0418\u0433\u0440\u043e\u043a", targetName);
            this.plugin.getDiscordBot().sendLogEmbed("\u2705 \u0420\u0410\u0417\u0411\u0410\u041d", Color.GREEN, logFields);
        }
        return true;
    }
}

