/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.commands;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.models.Warning;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnwarnCommand
implements CommandExecutor {
    private final EasyBan plugin;

    public UnwarnCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        int amount;
        if (!sender.hasPermission("easyban.unwarn")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args2.length < 2) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("usage", "/unwarn <player> <amount>");
            sender.sendMessage(this.plugin.getConfigManager().getMessage("insufficient-args", placeholders));
            return true;
        }
        String targetName = args2[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("player-never-joined", placeholders));
            return true;
        }
        try {
            amount = Integer.parseInt(args2[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-time-format"));
            return true;
        }
        List<Warning> warnings = this.plugin.getDatabaseManager().getActiveWarnings(target.getUniqueId());
        if (warnings.isEmpty()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-warnings", placeholders));
            return true;
        }
        this.plugin.getDatabaseManager().removeWarnings(target.getUniqueId(), amount);
        int remaining = Math.max(0, warnings.size() - amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        placeholders.put("amount", String.valueOf(amount));
        sender.sendMessage(this.plugin.getConfigManager().getMessage("unwarn-success", placeholders));
        if (target.isOnline()) {
            Player player = target.getPlayer();
            HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
            targetPlaceholders.put("amount", String.valueOf(amount));
            targetPlaceholders.put("warns", String.valueOf(remaining));
            String message = this.plugin.getConfigManager().getMessage("unwarn-notification", targetPlaceholders);
            player.sendMessage(message);
        }
        if (this.plugin.getDiscordBot() != null) {
            HashMap<String, String> logFields = new HashMap<String, String>();
            logFields.put("\ud83d\udd28 \u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", sender.getName());
            logFields.put("\ud83d\udc64 \u0418\u0433\u0440\u043e\u043a", targetName);
            logFields.put("\ud83d\udcca \u0421\u043d\u044f\u0442\u043e \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439", String.valueOf(amount));
            logFields.put("\u26a0\ufe0f \u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c", String.valueOf(remaining));
            this.plugin.getDiscordBot().sendLogEmbed("\u2705 \u0421\u041d\u042f\u0422\u0418\u0415 \u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0419", Color.GREEN, logFields);
        }
        return true;
    }
}

