/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.commands;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.utils.TimeUtils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class WarnCommand
implements CommandExecutor {
    private final EasyBan plugin;

    public WarnCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        int reasonStartIndex;
        if (!sender.hasPermission("easyban.warn")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args2.length < 2) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("usage", "/warn <player> <time> <reason> OR /warn <player> <reason>");
            sender.sendMessage(this.plugin.getConfigManager().getMessage("insufficient-args", placeholders));
            return true;
        }
        String targetName = args2[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("player-never-joined", placeholders));
            return true;
        }
        long duration = TimeUtils.parseTime(args2[1]);
        if (duration > 0L) {
            reasonStartIndex = 2;
        } else {
            duration = -1L;
            reasonStartIndex = 1;
        }
        StringBuilder reasonBuilder = new StringBuilder();
        for (int i = reasonStartIndex; i < args2.length; ++i) {
            reasonBuilder.append(args2[i]).append(" ");
        }
        String reason = reasonBuilder.toString().trim();
        if (reason.isEmpty()) {
            reason = this.plugin.getConfig().getString("default-reason", "Violation of server rules");
        }
        this.plugin.getPunishmentManager().warn(target, sender, reason, duration);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        placeholders.put("reason", reason);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("warn-success", placeholders));
        return true;
    }
}

