/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.database;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.models.Punishment;
import abstracktyt.easyban.models.Warning;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DatabaseManager {
    private final EasyBan plugin;
    private Connection connection;
    private boolean isSQLite;

    public DatabaseManager(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean initialize() {
        try {
            String dbType = this.plugin.getConfig().getString("database.type", "sqlite");
            this.isSQLite = dbType.equalsIgnoreCase("sqlite");
            if (this.isSQLite) {
                File dataFolder = this.plugin.getDataFolder();
                if (!dataFolder.exists()) {
                    dataFolder.mkdirs();
                }
                String url = "jdbc:sqlite:" + dataFolder.getAbsolutePath() + File.separator + "easyban.db";
                this.connection = DriverManager.getConnection(url);
            } else {
                String host = this.plugin.getConfig().getString("database.mysql.host");
                int port = this.plugin.getConfig().getInt("database.mysql.port");
                String database = this.plugin.getConfig().getString("database.mysql.database");
                String username = this.plugin.getConfig().getString("database.mysql.username");
                String password = this.plugin.getConfig().getString("database.mysql.password");
                String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
                this.connection = DriverManager.getConnection(url, username, password);
            }
            this.createTables();
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void createTables() throws SQLException {
        String punishmentsTable = this.isSQLite ? "CREATE TABLE IF NOT EXISTS punishments (id INTEGER PRIMARY KEY AUTOINCREMENT, target_uuid VARCHAR(36) NOT NULL, target_name VARCHAR(16) NOT NULL, moderator_uuid VARCHAR(36), moderator_name VARCHAR(16), type VARCHAR(20) NOT NULL, reason TEXT NOT NULL, timestamp BIGINT NOT NULL, expires BIGINT NOT NULL, ip VARCHAR(45), active BOOLEAN NOT NULL DEFAULT 1)" : "CREATE TABLE IF NOT EXISTS punishments (id INT AUTO_INCREMENT PRIMARY KEY, target_uuid VARCHAR(36) NOT NULL, target_name VARCHAR(16) NOT NULL, moderator_uuid VARCHAR(36), moderator_name VARCHAR(16), type VARCHAR(20) NOT NULL, reason TEXT NOT NULL, timestamp BIGINT NOT NULL, expires BIGINT NOT NULL, ip VARCHAR(45), active TINYINT(1) NOT NULL DEFAULT 1)";
        String warningsTable = this.isSQLite ? "CREATE TABLE IF NOT EXISTS warnings (id INTEGER PRIMARY KEY AUTOINCREMENT, target_uuid VARCHAR(36) NOT NULL, target_name VARCHAR(16) NOT NULL, moderator_uuid VARCHAR(36), moderator_name VARCHAR(16), reason TEXT NOT NULL, timestamp BIGINT NOT NULL, expires BIGINT NOT NULL, active BOOLEAN NOT NULL DEFAULT 1)" : "CREATE TABLE IF NOT EXISTS warnings (id INT AUTO_INCREMENT PRIMARY KEY, target_uuid VARCHAR(36) NOT NULL, target_name VARCHAR(16) NOT NULL, moderator_uuid VARCHAR(36), moderator_name VARCHAR(16), reason TEXT NOT NULL, timestamp BIGINT NOT NULL, expires BIGINT NOT NULL, active TINYINT(1) NOT NULL DEFAULT 1)";
        String linksTable = "CREATE TABLE IF NOT EXISTS discord_links (minecraft_uuid VARCHAR(36) PRIMARY KEY, minecraft_name VARCHAR(16) NOT NULL, discord_id VARCHAR(20) NOT NULL, link_code VARCHAR(10), linked_at BIGINT NOT NULL)";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(punishmentsTable);
            stmt.execute(warningsTable);
            stmt.execute(linksTable);
        }
    }

    public void savePunishment(Punishment punishment) {
        String sql = "INSERT INTO punishments (target_uuid, target_name, moderator_uuid, moderator_name, type, reason, timestamp, expires, ip, active) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, punishment.getTargetUuid().toString());
            stmt.setString(2, punishment.getTargetName());
            stmt.setString(3, punishment.getModeratorUuid() != null ? punishment.getModeratorUuid().toString() : null);
            stmt.setString(4, punishment.getModeratorName());
            stmt.setString(5, punishment.getType());
            stmt.setString(6, punishment.getReason());
            stmt.setLong(7, punishment.getTimestamp());
            stmt.setLong(8, punishment.getExpires());
            stmt.setString(9, punishment.getIp());
            stmt.setBoolean(10, punishment.isActive());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u043a\u0430\u0437\u0430\u043d\u0438\u0435: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Punishment getActiveBan(UUID uuid) {
        String sql = "SELECT * FROM punishments WHERE target_uuid = ? AND (type = 'BAN' OR type = 'TEMPBAN') AND active = 1 LIMIT 1";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            Punishment punishment = this.createPunishmentFromResultSet(rs);
            return punishment;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u0431\u0430\u043d: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Punishment getActiveIpBan(String ip) {
        String sql = "SELECT * FROM punishments WHERE ip = ? AND (type = 'IPBAN' OR type = 'TEMPIPBAN') AND active = 1 LIMIT 1";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, ip);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            Punishment punishment = this.createPunishmentFromResultSet(rs);
            return punishment;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get active IP ban: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Punishment getActiveMute(UUID uuid) {
        String sql = "SELECT * FROM punishments WHERE target_uuid = ? AND (type = 'MUTE' OR type = 'TEMPMUTE') AND active = 1 LIMIT 1";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            Punishment punishment = this.createPunishmentFromResultSet(rs);
            return punishment;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get active mute: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public void removePunishment(UUID uuid, String type) {
        String sql = "UPDATE punishments SET active = 0 WHERE target_uuid = ? AND type = ? AND active = 1";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, type);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to remove punishment: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void removeIpBan(String ip) {
        String sql = "UPDATE punishments SET active = 0 WHERE ip = ? AND (type = 'IPBAN' OR type = 'TEMPIPBAN') AND active = 1";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, ip);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to remove IP ban: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public List<Punishment> getPunishmentHistory(UUID uuid, String type) {
        ArrayList<Punishment> punishments = new ArrayList<Punishment>();
        String sql = type == null ? "SELECT * FROM punishments WHERE target_uuid = ? OR moderator_uuid = ? ORDER BY timestamp DESC" : "SELECT * FROM punishments WHERE (target_uuid = ? OR moderator_uuid = ?) AND type LIKE ? ORDER BY timestamp DESC";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, uuid.toString());
            if (type != null) {
                stmt.setString(3, "%" + type + "%");
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                punishments.add(this.createPunishmentFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get punishment history: " + e.getMessage());
            e.printStackTrace();
        }
        return punishments;
    }

    public void saveWarning(Warning warning) {
        String sql = "INSERT INTO warnings (target_uuid, target_name, moderator_uuid, moderator_name, reason, timestamp, expires, active) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, warning.getTargetUuid().toString());
            stmt.setString(2, warning.getTargetName());
            stmt.setString(3, warning.getModeratorUuid() != null ? warning.getModeratorUuid().toString() : null);
            stmt.setString(4, warning.getModeratorName());
            stmt.setString(5, warning.getReason());
            stmt.setLong(6, warning.getTimestamp());
            stmt.setLong(7, warning.getExpires());
            stmt.setBoolean(8, warning.isActive());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save warning: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public List<Warning> getActiveWarnings(UUID uuid) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        String sql = "SELECT * FROM warnings WHERE target_uuid = ? AND active = 1 ORDER BY timestamp DESC";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                warnings.add(this.createWarningFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get active warnings: " + e.getMessage());
            e.printStackTrace();
        }
        return warnings;
    }

    public List<Warning> getWarningHistory(UUID uuid) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        String sql = "SELECT * FROM warnings WHERE target_uuid = ? OR moderator_uuid = ? ORDER BY timestamp DESC";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, uuid.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                warnings.add(this.createWarningFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get warning history: " + e.getMessage());
            e.printStackTrace();
        }
        return warnings;
    }

    public void removeWarnings(UUID uuid, int amount) {
        Object sql = "SELECT id FROM warnings WHERE target_uuid = ? AND active = 1 ORDER BY timestamp DESC LIMIT ?";
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try (PreparedStatement stmt = this.connection.prepareStatement((String)sql);){
            stmt.setString(1, uuid.toString());
            stmt.setInt(2, amount);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getInt("id"));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get warnings to remove: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        if (!ids.isEmpty()) {
            StringBuilder placeholders = new StringBuilder();
            for (int i = 0; i < ids.size(); ++i) {
                placeholders.append("?");
                if (i >= ids.size() - 1) continue;
                placeholders.append(",");
            }
            sql = "UPDATE warnings SET active = 0 WHERE id IN (" + placeholders.toString() + ")";
            try (PreparedStatement stmt = this.connection.prepareStatement((String)sql);){
                for (int i = 0; i < ids.size(); ++i) {
                    stmt.setInt(i + 1, (Integer)ids.get(i));
                }
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to remove warnings: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void saveLinkCode(UUID uuid, String username, String code) {
        String sql = this.isSQLite ? "INSERT OR REPLACE INTO discord_links (minecraft_uuid, minecraft_name, link_code, discord_id, linked_at) VALUES (?, ?, ?, '', 0)" : "REPLACE INTO discord_links (minecraft_uuid, minecraft_name, link_code, discord_id, linked_at) VALUES (?, ?, ?, '', 0)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, username);
            stmt.setString(3, code);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save link code: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getUuidByLinkCode(String code) {
        String sql = "SELECT minecraft_uuid FROM discord_links WHERE link_code = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, code);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString("minecraft_uuid"));
            return uUID;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get UUID by link code: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public void linkDiscordAccount(UUID uuid, String username, String discordId) {
        String sql = "UPDATE discord_links SET discord_id = ?, minecraft_name = ?, linked_at = ?, link_code = NULL WHERE minecraft_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, discordId);
            stmt.setString(2, username);
            stmt.setLong(3, System.currentTimeMillis() / 1000L);
            stmt.setString(4, uuid.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to link Discord account: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getUuidByDiscordId(String discordId) {
        String sql = "SELECT minecraft_uuid FROM discord_links WHERE discord_id = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, discordId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString("minecraft_uuid"));
            return uUID;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get UUID by Discord ID: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDiscordIdByUuid(UUID uuid) {
        String sql = "SELECT discord_id FROM discord_links WHERE minecraft_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            String string = rs.getString("discord_id");
            return string;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get Discord ID by UUID: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    private Punishment createPunishmentFromResultSet(ResultSet rs) throws SQLException {
        UUID targetUuid = UUID.fromString(rs.getString("target_uuid"));
        String targetName = rs.getString("target_name");
        String modUuidStr = rs.getString("moderator_uuid");
        UUID moderatorUuid = modUuidStr != null ? UUID.fromString(modUuidStr) : null;
        String moderatorName = rs.getString("moderator_name");
        String type = rs.getString("type");
        String reason = rs.getString("reason");
        long timestamp = rs.getLong("timestamp");
        long expires = rs.getLong("expires");
        String ip = rs.getString("ip");
        Punishment punishment = new Punishment(targetUuid, targetName, moderatorUuid, moderatorName, type, reason, timestamp, expires, ip);
        punishment.setId(rs.getInt("id"));
        punishment.setActive(rs.getBoolean("active"));
        return punishment;
    }

    private Warning createWarningFromResultSet(ResultSet rs) throws SQLException {
        UUID targetUuid = UUID.fromString(rs.getString("target_uuid"));
        String targetName = rs.getString("target_name");
        String modUuidStr = rs.getString("moderator_uuid");
        UUID moderatorUuid = modUuidStr != null ? UUID.fromString(modUuidStr) : null;
        String moderatorName = rs.getString("moderator_name");
        String reason = rs.getString("reason");
        long timestamp = rs.getLong("timestamp");
        long expires = rs.getLong("expires");
        Warning warning = new Warning(targetUuid, targetName, moderatorUuid, moderatorName, reason, timestamp, expires);
        warning.setId(rs.getInt("id"));
        warning.setActive(rs.getBoolean("active"));
        return warning;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to close database connection: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

