/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.discord;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.discord.commands.BanHistoryDiscordCommand;
import abstracktyt.easyban.discord.commands.BanInfoDiscordCommand;
import abstracktyt.easyban.discord.commands.DiscordCommand;
import abstracktyt.easyban.discord.commands.HelpDiscordCommand;
import abstracktyt.easyban.discord.commands.KickHistoryDiscordCommand;
import abstracktyt.easyban.discord.commands.KickInfoDiscordCommand;
import abstracktyt.easyban.discord.commands.LinkDiscordCommand;
import abstracktyt.easyban.discord.commands.MuteHistoryDiscordCommand;
import abstracktyt.easyban.discord.commands.MuteInfoDiscordCommand;
import abstracktyt.easyban.discord.commands.TempBanDiscordCommand;
import abstracktyt.easyban.discord.commands.TempBanIpDiscordCommand;
import abstracktyt.easyban.discord.commands.TempMuteDiscordCommand;
import abstracktyt.easyban.discord.commands.TempMuteIpDiscordCommand;
import abstracktyt.easyban.discord.commands.UnbanDiscordCommand;
import abstracktyt.easyban.discord.commands.UnbanIpDiscordCommand;
import abstracktyt.easyban.discord.commands.UnmuteDiscordCommand;
import abstracktyt.easyban.discord.commands.UnmuteIpDiscordCommand;
import abstracktyt.easyban.discord.commands.UnwarnDiscordCommand;
import abstracktyt.easyban.discord.commands.WarnDiscordCommand;
import abstracktyt.easyban.discord.commands.WarnHistoryDiscordCommand;
import abstracktyt.easyban.discord.commands.WarnInfoDiscordCommand;
import java.awt.Color;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;

public class DiscordBot
extends ListenerAdapter {
    private final EasyBan plugin;
    private JDA jda;
    private final Map<String, DiscordCommand> commands;
    private String prefix;

    public DiscordBot(EasyBan plugin) {
        this.plugin = plugin;
        this.commands = new HashMap<String, DiscordCommand>();
        this.prefix = plugin.getConfig().getString("discord.command-prefix", "!");
        this.registerCommands();
    }

    public boolean start() {
        String token = this.plugin.getConfig().getString("discord.token");
        if (token == null || token.equals("YOUR_DISCORD_BOT_TOKEN_HERE")) {
            this.plugin.getLogger().warning("\u0422\u043e\u043a\u0435\u043d Discord \u0431\u043e\u0442\u0430 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0432 config.yml!");
            return false;
        }
        try {
            String activityType = this.plugin.getConfig().getString("discord.activity.type", "WATCHING");
            String activityText = this.plugin.getConfig().getString("discord.activity.text", "Minecraft Server");
            Activity activity = this.createActivity(activityType, activityText);
            this.jda = JDABuilder.createDefault(token).enableIntents(GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MESSAGES).addEventListeners(this).setActivity(activity).build();
            this.jda.awaitReady();
            this.plugin.getLogger().info("Discord \u0431\u043e\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d!");
            this.plugin.getLogger().info("\u0421\u0442\u0430\u0442\u0443\u0441 \u0431\u043e\u0442\u0430: " + activityType + " " + activityText);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c Discord \u0431\u043e\u0442\u0430: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private Activity createActivity(String type, String text) {
        switch (type.toUpperCase()) {
            case "PLAYING": {
                return Activity.playing(text);
            }
            case "LISTENING": {
                return Activity.listening(text);
            }
            case "COMPETING": {
                return Activity.competing(text);
            }
        }
        return Activity.watching(text);
    }

    private void registerCommands() {
        this.commands.put("tm", new TempMuteDiscordCommand(this.plugin));
        this.commands.put("tmip", new TempMuteIpDiscordCommand(this.plugin));
        this.commands.put("tb", new TempBanDiscordCommand(this.plugin));
        this.commands.put("tbip", new TempBanIpDiscordCommand(this.plugin));
        this.commands.put("unban", new UnbanDiscordCommand(this.plugin));
        this.commands.put("unbanip", new UnbanIpDiscordCommand(this.plugin));
        this.commands.put("unmute", new UnmuteDiscordCommand(this.plugin));
        this.commands.put("unmuteip", new UnmuteIpDiscordCommand(this.plugin));
        this.commands.put("warn", new WarnDiscordCommand(this.plugin));
        this.commands.put("unwarn", new UnwarnDiscordCommand(this.plugin));
        this.commands.put("warnhistory", new WarnHistoryDiscordCommand(this.plugin));
        this.commands.put("warninfo", new WarnInfoDiscordCommand(this.plugin));
        this.commands.put("banhistory", new BanHistoryDiscordCommand(this.plugin));
        this.commands.put("mutehistory", new MuteHistoryDiscordCommand(this.plugin));
        this.commands.put("kickhistory", new KickHistoryDiscordCommand(this.plugin));
        this.commands.put("baninfo", new BanInfoDiscordCommand(this.plugin));
        this.commands.put("muteinfo", new MuteInfoDiscordCommand(this.plugin));
        this.commands.put("kickinfo", new KickInfoDiscordCommand(this.plugin));
        this.commands.put("link", new LinkDiscordCommand(this.plugin));
        this.commands.put("help", new HelpDiscordCommand(this.plugin));
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        String message = event.getMessage().getContentRaw();
        if (!message.startsWith(this.prefix)) {
            return;
        }
        String[] parts = message.substring(this.prefix.length()).split("\\s+");
        String commandName = parts[0].toLowerCase();
        String[] args2 = new String[parts.length - 1];
        System.arraycopy(parts, 1, args2, 0, args2.length);
        DiscordCommand command = this.commands.get(commandName);
        if (command != null) {
            command.execute(event, args2);
        }
    }

    public void shutdown() {
        if (this.jda != null) {
            this.jda.shutdown();
        }
    }

    public JDA getJda() {
        return this.jda;
    }

    public void sendLog(String message) {
        String channelId = this.plugin.getConfig().getString("discord.log-channel", "0");
        if (channelId == null || channelId.equals("0") || channelId.isEmpty()) {
            return;
        }
        try {
            if (this.jda != null) {
                this.jda.getTextChannelById(channelId).sendMessage(message).queue();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043b\u043e\u0433 \u0432 Discord: " + e.getMessage());
        }
    }

    public void sendLogEmbed(String title, Color color, Map<String, String> fields) {
        String channelId = this.plugin.getConfig().getString("discord.log-channel", "0");
        if (channelId == null || channelId.equals("0") || channelId.isEmpty()) {
            return;
        }
        try {
            if (this.jda != null) {
                EmbedBuilder embed = new EmbedBuilder();
                embed.setTitle(title);
                embed.setColor(color);
                embed.setTimestamp(Instant.now());
                for (Map.Entry<String, String> entry : fields.entrySet()) {
                    embed.addField(entry.getKey(), entry.getValue(), true);
                }
                this.jda.getTextChannelById(channelId).sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c embed \u043b\u043e\u0433 \u0432 Discord: " + e.getMessage());
        }
    }
}

