/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.discord.commands;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.discord.commands.DiscordCommand;
import abstracktyt.easyban.models.Punishment;
import abstracktyt.easyban.utils.TimeUtils;
import java.awt.Color;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class BanInfoDiscordCommand
implements DiscordCommand {
    private final EasyBan plugin;

    public BanInfoDiscordCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(MessageReceivedEvent event, String[] args2) {
        if (args2.length < 1) {
            event.getChannel().sendMessage("\u274c \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: !baninfo <\u043d\u0438\u043a> [\u043f\u0435\u0440\u0438\u043e\u0434]").queue();
            return;
        }
        String targetName = args2[0];
        String period = args2.length > 1 ? args2[1] : "\u0432\u0441\u0451 \u0432\u0440\u0435\u043c\u044f";
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<Punishment> history = this.plugin.getDatabaseManager().getPunishmentHistory(target.getUniqueId(), "BAN");
            long periodSeconds = 0L;
            if (!(period.equals("\u0432\u0441\u0451 \u0432\u0440\u0435\u043c\u044f") || period.equals("\u0432\u0441\u0435") || period.equals("all"))) {
                periodSeconds = TimeUtils.parseTime(period);
            }
            long cutoffTime = periodSeconds > 0L ? TimeUtils.currentTimeSeconds() - periodSeconds : 0L;
            int issuedCount = 0;
            int tempBanCount = 0;
            int permBanCount = 0;
            for (Punishment p : history) {
                if (periodSeconds > 0L && p.getTimestamp() < cutoffTime || p.getModeratorUuid() == null || !p.getModeratorUuid().equals(target.getUniqueId())) continue;
                ++issuedCount;
                if (p.getType().equals("TEMPBAN")) {
                    ++tempBanCount;
                    continue;
                }
                ++permBanCount;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle("\ud83d\udcca \u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0431\u0430\u043d\u043e\u0432: " + targetName);
            embed.setColor(Color.BLUE);
            embed.addField("\ud83d\udcc5 \u041f\u0435\u0440\u0438\u043e\u0434", period, true);
            embed.addField("\ud83d\udd28 \u0412\u0441\u0435\u0433\u043e \u0432\u044b\u0434\u0430\u043d\u043e", String.valueOf(issuedCount), true);
            embed.addField("\u23f1\ufe0f \u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445", String.valueOf(tempBanCount), true);
            embed.addField("\u267e\ufe0f \u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0445", String.valueOf(permBanCount), true);
            event.getChannel().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        });
    }
}

