/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.discord.commands;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.discord.commands.DiscordCommand;
import abstracktyt.easyban.models.Punishment;
import abstracktyt.easyban.utils.TimeUtils;
import java.awt.Color;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class MuteHistoryDiscordCommand
implements DiscordCommand {
    private final EasyBan plugin;

    public MuteHistoryDiscordCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(MessageReceivedEvent event, String[] args2) {
        if (args2.length < 1) {
            event.getChannel().sendMessage("\u274c \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: !mutehistory <\u043d\u0438\u043a>").queue();
            return;
        }
        String targetName = args2[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<Punishment> history = this.plugin.getDatabaseManager().getPunishmentHistory(target.getUniqueId(), "MUTE");
            if (history.isEmpty()) {
                event.getChannel().sendMessage("\ud83d\udccb \u0423 \u0438\u0433\u0440\u043e\u043a\u0430 `" + targetName + "` \u043d\u0435\u0442 \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u043c\u0443\u0442\u043e\u0432.").queue();
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle("\ud83d\udd07 \u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043c\u0443\u0442\u043e\u0432: " + targetName);
            embed.setColor(Color.ORANGE);
            int receivedCount = 0;
            int issuedCount = 0;
            StringBuilder received = new StringBuilder();
            StringBuilder issued = new StringBuilder();
            for (Punishment p : history) {
                String line;
                if (p.getTargetUuid().equals(target.getUniqueId())) {
                    line = String.format("**%s** | %s | \u041e\u0442: %s | %s\n", TimeUtils.formatDate(p.getTimestamp() * 1000L), p.getType(), p.getModeratorName(), p.getReason());
                    received.append(line);
                    ++receivedCount;
                    continue;
                }
                if (p.getModeratorUuid() == null || !p.getModeratorUuid().equals(target.getUniqueId())) continue;
                line = String.format("**%s** | %s | \u041a\u043e\u043c\u0443: %s | %s\n", TimeUtils.formatDate(p.getTimestamp() * 1000L), p.getType(), p.getTargetName(), p.getReason());
                issued.append(line);
                ++issuedCount;
            }
            if (receivedCount > 0) {
                Object receivedText = received.toString();
                if (((String)receivedText).length() > 1024) {
                    receivedText = ((String)receivedText).substring(0, 1020) + "...";
                }
                embed.addField("\ud83d\udd34 \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e (" + receivedCount + ")", (String)receivedText, false);
            }
            if (issuedCount > 0) {
                Object issuedText = issued.toString();
                if (((String)issuedText).length() > 1024) {
                    issuedText = ((String)issuedText).substring(0, 1020) + "...";
                }
                embed.addField("\ud83d\udd28 \u0412\u044b\u0434\u0430\u043d\u043e (" + issuedCount + ")", (String)issuedText, false);
            }
            event.getChannel().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        });
    }
}

