/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.discord.commands;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.discord.commands.DiscordCommand;
import abstracktyt.easyban.models.Warning;
import abstracktyt.easyban.utils.TimeUtils;
import java.awt.Color;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class WarnHistoryDiscordCommand
implements DiscordCommand {
    private final EasyBan plugin;

    public WarnHistoryDiscordCommand(EasyBan plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(MessageReceivedEvent event, String[] args2) {
        if (args2.length < 1) {
            event.getChannel().sendMessage("\u274c \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: !warnhistory <\u043d\u0438\u043a>").queue();
            return;
        }
        String targetName = args2[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<Warning> warnings = this.plugin.getDatabaseManager().getActiveWarnings(target.getUniqueId());
            if (warnings.isEmpty()) {
                event.getChannel().sendMessage("\ud83d\udccb \u0423 \u0438\u0433\u0440\u043e\u043a\u0430 `" + targetName + "` \u043d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439.").queue();
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle("\u26a0\ufe0f \u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f: " + targetName);
            embed.setColor(Color.ORANGE);
            embed.setDescription("\u0412\u0441\u0435\u0433\u043e: " + warnings.size());
            StringBuilder list = new StringBuilder();
            int count = 0;
            for (Warning w : warnings) {
                if (++count > 10) {
                    list.append("*... \u0438 \u0435\u0449\u0435 ").append(warnings.size() - 10).append(" \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439*\n");
                    break;
                }
                String expiry = w.isPermanent() ? "\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e" : TimeUtils.formatDate(w.getExpires() * 1000L);
                list.append(String.format("**%d.** %s | \u041e\u0442: %s | %s | \u0418\u0441\u0442\u0435\u043a\u0430\u0435\u0442: %s\n", count, TimeUtils.formatDate(w.getTimestamp() * 1000L), w.getModeratorName(), w.getReason(), expiry));
            }
            embed.addField("\u0421\u043f\u0438\u0441\u043e\u043a", list.toString(), false);
            event.getChannel().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        });
    }
}

