/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.listeners;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.models.Punishment;
import abstracktyt.easyban.utils.TimeUtils;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final EasyBan plugin;

    public ChatListener(EasyBan plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Punishment mute = this.plugin.getDatabaseManager().getActiveMute(uuid);
        if (mute != null) {
            if (mute.isExpired()) {
                this.plugin.getDatabaseManager().removePunishment(uuid, mute.getType());
            } else {
                event.setCancelled(true);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("reason", mute.getReason());
                if (mute.isPermanent()) {
                    placeholders.put("expires", "\u041d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
                } else {
                    long remaining = mute.getExpires() - TimeUtils.currentTimeSeconds();
                    placeholders.put("expires", TimeUtils.formatTime(remaining));
                }
                String message = this.plugin.getConfigManager().getMessage("muted-message", placeholders);
                player.sendMessage(message);
            }
        }
    }
}

