/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.listeners;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.models.Punishment;
import abstracktyt.easyban.utils.TimeUtils;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

public class ConnectionListener
implements Listener {
    private final EasyBan plugin;

    public ConnectionListener(EasyBan plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(AsyncPlayerPreLoginEvent event) {
        Punishment ipBan;
        UUID uuid = event.getUniqueId();
        String ip = event.getAddress().getHostAddress();
        Punishment uuidBan = this.plugin.getDatabaseManager().getActiveBan(uuid);
        if (uuidBan != null) {
            if (uuidBan.isExpired()) {
                this.plugin.getDatabaseManager().removePunishment(uuid, uuidBan.getType());
            } else {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, this.buildBanMessage(uuidBan));
                return;
            }
        }
        if ((ipBan = this.plugin.getDatabaseManager().getActiveIpBan(ip)) != null) {
            if (ipBan.isExpired()) {
                this.plugin.getDatabaseManager().removeIpBan(ip);
            } else {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, this.buildBanMessage(ipBan));
                return;
            }
        }
    }

    private String buildBanMessage(Punishment punishment) {
        String messageKey;
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("reason", punishment.getReason());
        placeholders.put("moderator", punishment.getModeratorName());
        placeholders.put("date", TimeUtils.formatDate(punishment.getTimestamp() * 1000L));
        if (punishment.isPermanent()) {
            messageKey = "ban-screen-permanent";
        } else {
            messageKey = "ban-screen";
            placeholders.put("expires", TimeUtils.formatDate(punishment.getExpires() * 1000L));
        }
        return this.plugin.getConfigManager().getMessage(messageKey, placeholders);
    }
}

