/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.managers;

import abstracktyt.easyban.EasyBan;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final EasyBan plugin;
    private FileConfiguration messagesConfig;

    public ConfigManager(EasyBan plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    public String getMessage(String path) {
        return this.getMessage(path, new HashMap<String, String>());
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String message = this.messagesConfig.getString(path, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
        String prefix = this.messagesConfig.getString("prefix", "&8[&cEasyBan&8]&r ");
        message = message.replace("{prefix}", prefix);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public long getTimeLimit(String permission) {
        return this.plugin.getConfig().getLong("time-limits." + permission, -1L);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.loadMessages();
    }
}

