/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.managers;

import abstracktyt.easyban.EasyBan;
import java.util.Random;
import java.util.UUID;

public class LinkManager {
    private final EasyBan plugin;
    private final Random random;

    public LinkManager(EasyBan plugin) {
        this.plugin = plugin;
        this.random = new Random();
    }

    public String generateLinkCode(UUID uuid, String username) {
        String code = this.generateRandomCode();
        this.plugin.getDatabaseManager().saveLinkCode(uuid, username, code);
        return code;
    }

    public boolean linkAccount(String code, String discordId) {
        UUID uuid = this.plugin.getDatabaseManager().getUuidByLinkCode(code);
        if (uuid == null) {
            return false;
        }
        String username = this.plugin.getServer().getOfflinePlayer(uuid).getName();
        this.plugin.getDatabaseManager().linkDiscordAccount(uuid, username, discordId);
        return true;
    }

    public UUID getMinecraftUuid(String discordId) {
        return this.plugin.getDatabaseManager().getUuidByDiscordId(discordId);
    }

    public String getDiscordId(UUID uuid) {
        return this.plugin.getDatabaseManager().getDiscordIdByUuid(uuid);
    }

    public boolean isLinked(UUID uuid) {
        String discordId = this.getDiscordId(uuid);
        return discordId != null && !discordId.isEmpty();
    }

    public boolean isLinked(String discordId) {
        UUID uuid = this.getMinecraftUuid(discordId);
        return uuid != null;
    }

    private String generateRandomCode() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            code.append(chars.charAt(this.random.nextInt(chars.length())));
        }
        return code.toString();
    }
}

