/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.managers;

import abstracktyt.easyban.EasyBan;
import abstracktyt.easyban.discord.DiscordCommandSender;
import abstracktyt.easyban.models.Punishment;
import abstracktyt.easyban.models.Warning;
import abstracktyt.easyban.utils.TimeUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PunishmentManager {
    private final EasyBan plugin;

    public PunishmentManager(EasyBan plugin) {
        this.plugin = plugin;
    }

    public boolean canPunishFor(CommandSender sender, long duration) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        for (String permission : this.plugin.getConfig().getConfigurationSection("time-limits").getKeys(false)) {
            if (!player.hasPermission(permission)) continue;
            long maxTime = this.plugin.getConfigManager().getTimeLimit(permission);
            if (maxTime == -1L) {
                return true;
            }
            if (duration > maxTime) continue;
            return true;
        }
        return false;
    }

    public long getMaxPunishmentTime(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return -1L;
        }
        Player player = (Player)sender;
        long maxTime = 0L;
        for (String permission : this.plugin.getConfig().getConfigurationSection("time-limits").getKeys(false)) {
            if (!player.hasPermission(permission)) continue;
            long time = this.plugin.getConfigManager().getTimeLimit(permission);
            if (time == -1L) {
                return -1L;
            }
            maxTime = Math.max(maxTime, time);
        }
        return maxTime;
    }

    public void ban(OfflinePlayer target, CommandSender moderator, String reason, long duration) {
        UUID targetUuid = target.getUniqueId();
        String targetName = target.getName();
        UUID modUuid = null;
        if (moderator instanceof Player) {
            modUuid = ((Player)moderator).getUniqueId();
        } else if (moderator instanceof DiscordCommandSender) {
            modUuid = ((DiscordCommandSender)moderator).getUniqueId();
        }
        String modName = moderator.getName();
        long timestamp = TimeUtils.currentTimeSeconds();
        long expires = duration > 0L ? timestamp + duration : -1L;
        String type = duration > 0L ? "TEMPBAN" : "BAN";
        Punishment punishment = new Punishment(targetUuid, targetName, modUuid, modName, type, reason, timestamp, expires, null);
        this.plugin.getDatabaseManager().savePunishment(punishment);
        if (target.isOnline()) {
            Player player = target.getPlayer();
            String kickMessage = this.buildBanMessage(punishment);
            player.kickPlayer(kickMessage);
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        placeholders.put("moderator", modName);
        placeholders.put("reason", reason);
        placeholders.put("time", duration > 0L ? TimeUtils.formatTime(duration) : "\u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
        String messageKey = duration > 0L ? "tempban-broadcast" : "ban-broadcast";
        String broadcastMessage = this.plugin.getConfigManager().getMessage(messageKey, placeholders);
        Bukkit.broadcast((String)broadcastMessage, (String)"easyban.notify");
        if (this.plugin.getDiscordBot() != null) {
            HashMap<String, String> logFields = new HashMap<String, String>();
            logFields.put("\ud83d\udd28 \u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", modName);
            logFields.put("\ud83d\udc64 \u0418\u0433\u0440\u043e\u043a", targetName);
            logFields.put("\ud83d\udcdd \u041f\u0440\u0438\u0447\u0438\u043d\u0430", reason);
            logFields.put("\u23f0 \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", duration > 0L ? TimeUtils.formatTime(duration) : "\u041d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
            this.plugin.getDiscordBot().sendLogEmbed("\ud83d\udd28 \u0411\u0410\u041d", duration > 0L ? Color.ORANGE : Color.RED, logFields);
        }
    }

    public void ipban(String ip, OfflinePlayer target, CommandSender moderator, String reason, long duration) {
        UUID targetUuid = target.getUniqueId();
        String targetName = target.getName();
        UUID modUuid = null;
        if (moderator instanceof Player) {
            modUuid = ((Player)moderator).getUniqueId();
        } else if (moderator instanceof DiscordCommandSender) {
            modUuid = ((DiscordCommandSender)moderator).getUniqueId();
        }
        String modName = moderator.getName();
        long timestamp = TimeUtils.currentTimeSeconds();
        long expires = duration > 0L ? timestamp + duration : -1L;
        String type = duration > 0L ? "TEMPIPBAN" : "IPBAN";
        Punishment punishment = new Punishment(targetUuid, targetName, modUuid, modName, type, reason, timestamp, expires, ip);
        this.plugin.getDatabaseManager().savePunishment(punishment);
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (online.getAddress() == null || !online.getAddress().getAddress().getHostAddress().equals(ip)) continue;
            String kickMessage = this.buildBanMessage(punishment);
            online.kickPlayer(kickMessage);
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        placeholders.put("moderator", modName);
        placeholders.put("reason", reason);
        placeholders.put("time", duration > 0L ? TimeUtils.formatTime(duration) : "\u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
        String messageKey = duration > 0L ? "tempipban-success" : "ipban-success";
        String message = this.plugin.getConfigManager().getMessage(messageKey, placeholders);
        moderator.sendMessage(message);
        if (this.plugin.getDiscordBot() != null) {
            HashMap<String, String> logFields = new HashMap<String, String>();
            logFields.put("\ud83d\udd28 \u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", modName);
            logFields.put("\ud83d\udc64 \u0418\u0433\u0440\u043e\u043a", targetName);
            logFields.put("\ud83c\udf10 IP \u0430\u0434\u0440\u0435\u0441", ip);
            logFields.put("\ud83d\udcdd \u041f\u0440\u0438\u0447\u0438\u043d\u0430", reason);
            logFields.put("\u23f0 \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", duration > 0L ? TimeUtils.formatTime(duration) : "\u041d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
            this.plugin.getDiscordBot().sendLogEmbed("\ud83c\udf10 IP \u0411\u0410\u041d", duration > 0L ? Color.ORANGE : Color.RED, logFields);
        }
    }

    public void mute(OfflinePlayer target, CommandSender moderator, String reason, long duration) {
        UUID targetUuid = target.getUniqueId();
        String targetName = target.getName();
        UUID modUuid = null;
        if (moderator instanceof Player) {
            modUuid = ((Player)moderator).getUniqueId();
        } else if (moderator instanceof DiscordCommandSender) {
            modUuid = ((DiscordCommandSender)moderator).getUniqueId();
        }
        String modName = moderator.getName();
        long timestamp = TimeUtils.currentTimeSeconds();
        long expires = duration > 0L ? timestamp + duration : -1L;
        String type = duration > 0L ? "TEMPMUTE" : "MUTE";
        Punishment punishment = new Punishment(targetUuid, targetName, modUuid, modName, type, reason, timestamp, expires, null);
        this.plugin.getDatabaseManager().savePunishment(punishment);
        if (target.isOnline()) {
            Player player = target.getPlayer();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("reason", reason);
            placeholders.put("expires", duration > 0L ? TimeUtils.formatTime(duration) : "\u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
            String message = this.plugin.getConfigManager().getMessage("muted-message", placeholders);
            player.sendMessage(message);
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        placeholders.put("moderator", modName);
        placeholders.put("reason", reason);
        placeholders.put("time", duration > 0L ? TimeUtils.formatTime(duration) : "\u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
        String messageKey = duration > 0L ? "tempmute-broadcast" : "mute-broadcast";
        String broadcastMessage = this.plugin.getConfigManager().getMessage(messageKey, placeholders);
        Bukkit.broadcast((String)broadcastMessage, (String)"easyban.notify");
        if (this.plugin.getDiscordBot() != null) {
            HashMap<String, String> logFields = new HashMap<String, String>();
            logFields.put("\ud83d\udd28 \u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", modName);
            logFields.put("\ud83d\udc64 \u0418\u0433\u0440\u043e\u043a", targetName);
            logFields.put("\ud83d\udcdd \u041f\u0440\u0438\u0447\u0438\u043d\u0430", reason);
            logFields.put("\u23f0 \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", duration > 0L ? TimeUtils.formatTime(duration) : "\u041d\u0430\u0432\u0441\u0435\u0433\u0434\u0430");
            this.plugin.getDiscordBot().sendLogEmbed("\ud83d\udd07 \u041c\u0423\u0422", duration > 0L ? Color.YELLOW : Color.ORANGE, logFields);
        }
    }

    public void kick(Player target, CommandSender moderator, String reason) {
        String targetName = target.getName();
        UUID targetUuid = target.getUniqueId();
        UUID modUuid = null;
        if (moderator instanceof Player) {
            modUuid = ((Player)moderator).getUniqueId();
        } else if (moderator instanceof DiscordCommandSender) {
            modUuid = ((DiscordCommandSender)moderator).getUniqueId();
        }
        String modName = moderator.getName();
        long timestamp = TimeUtils.currentTimeSeconds();
        Punishment punishment = new Punishment(targetUuid, targetName, modUuid, modName, "KICK", reason, timestamp, -1L, null);
        this.plugin.getDatabaseManager().savePunishment(punishment);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("reason", reason);
        placeholders.put("moderator", modName);
        String kickMessage = this.plugin.getConfigManager().getMessage("kick-message", placeholders);
        target.kickPlayer(kickMessage);
        placeholders.put("player", targetName);
        String broadcastMessage = this.plugin.getConfigManager().getMessage("kick-broadcast", placeholders);
        Bukkit.broadcast((String)broadcastMessage, (String)"easyban.notify");
        if (this.plugin.getDiscordBot() != null) {
            HashMap<String, String> logFields = new HashMap<String, String>();
            logFields.put("\ud83d\udd28 \u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", modName);
            logFields.put("\ud83d\udc64 \u0418\u0433\u0440\u043e\u043a", targetName);
            logFields.put("\ud83d\udcdd \u041f\u0440\u0438\u0447\u0438\u043d\u0430", reason);
            this.plugin.getDiscordBot().sendLogEmbed("\ud83d\udc62 \u041a\u0418\u041a", Color.CYAN, logFields);
        }
    }

    public void warn(OfflinePlayer target, CommandSender moderator, String reason, long duration) {
        UUID targetUuid = target.getUniqueId();
        String targetName = target.getName();
        UUID modUuid = null;
        if (moderator instanceof Player) {
            modUuid = ((Player)moderator).getUniqueId();
        } else if (moderator instanceof DiscordCommandSender) {
            modUuid = ((DiscordCommandSender)moderator).getUniqueId();
        }
        String modName = moderator.getName();
        long timestamp = TimeUtils.currentTimeSeconds();
        long expires = duration > 0L ? timestamp + duration : -1L;
        Warning warning = new Warning(targetUuid, targetName, modUuid, modName, reason, timestamp, expires);
        this.plugin.getDatabaseManager().saveWarning(warning);
        int totalWarnings = this.plugin.getDatabaseManager().getActiveWarnings(targetUuid).size();
        if (target.isOnline()) {
            Player player = target.getPlayer();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("reason", reason);
            placeholders.put("warns", String.valueOf(totalWarnings));
            String message = this.plugin.getConfigManager().getMessage("warn-received", placeholders);
            player.sendMessage(message);
        }
        this.checkAutoPunish(target, totalWarnings);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetName);
        placeholders.put("moderator", modName);
        placeholders.put("reason", reason);
        String broadcastMessage = this.plugin.getConfigManager().getMessage("warn-broadcast", placeholders);
        Bukkit.broadcast((String)broadcastMessage, (String)"easyban.notify");
        if (this.plugin.getDiscordBot() != null) {
            HashMap<String, String> logFields = new HashMap<String, String>();
            logFields.put("\ud83d\udd28 \u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", modName);
            logFields.put("\ud83d\udc64 \u0418\u0433\u0440\u043e\u043a", targetName);
            logFields.put("\ud83d\udcdd \u041f\u0440\u0438\u0447\u0438\u043d\u0430", reason);
            logFields.put("\u26a0\ufe0f \u0412\u0441\u0435\u0433\u043e \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439", String.valueOf(totalWarnings));
            this.plugin.getDiscordBot().sendLogEmbed("\u26a0\ufe0f \u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415", new Color(255, 165, 0), logFields);
        }
    }

    private void checkAutoPunish(OfflinePlayer target, int warnings) {
        if (!this.plugin.getConfig().getBoolean("auto-punish.enabled", false)) {
            return;
        }
        String autoPunishKey = warnings + "-warnings";
        String punishment = this.plugin.getConfig().getString("auto-punish." + autoPunishKey);
        if (punishment != null) {
            String[] parts = punishment.split(" ", 3);
            String type = parts[0];
            if (type.equalsIgnoreCase("ban")) {
                String reason = parts.length > 1 ? punishment.substring(4) : "Auto-ban";
                this.ban(target, (CommandSender)Bukkit.getConsoleSender(), reason, -1L);
            } else if (type.equalsIgnoreCase("tempban")) {
                long duration = TimeUtils.parseTime(parts[1]);
                String reason = parts.length > 2 ? parts[2] : "Auto-ban";
                this.ban(target, (CommandSender)Bukkit.getConsoleSender(), reason, duration);
            }
        }
    }

    private String buildBanMessage(Punishment punishment) {
        String messageKey;
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("reason", punishment.getReason());
        placeholders.put("moderator", punishment.getModeratorName());
        placeholders.put("date", TimeUtils.formatDate(punishment.getTimestamp() * 1000L));
        if (punishment.isPermanent()) {
            messageKey = "ban-screen-permanent";
        } else {
            messageKey = "ban-screen";
            placeholders.put("expires", TimeUtils.formatDate(punishment.getExpires() * 1000L));
        }
        return this.plugin.getConfigManager().getMessage(messageKey, placeholders);
    }

    public boolean isBanned(UUID uuid) {
        Punishment ban = this.plugin.getDatabaseManager().getActiveBan(uuid);
        if (ban != null && !ban.isExpired()) {
            return true;
        }
        if (ban != null && ban.isExpired()) {
            this.plugin.getDatabaseManager().removePunishment(uuid, ban.getType());
        }
        return false;
    }

    public boolean isMuted(UUID uuid) {
        Punishment mute = this.plugin.getDatabaseManager().getActiveMute(uuid);
        if (mute != null && !mute.isExpired()) {
            return true;
        }
        if (mute != null && mute.isExpired()) {
            this.plugin.getDatabaseManager().removePunishment(uuid, mute.getType());
        }
        return false;
    }
}

