/*
 * Decompiled with CFR 0.152.
 */
package abstracktyt.easyban.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)([smhdwy])");

    public static long parseTime(String time) {
        if (time == null || time.isEmpty()) {
            return -1L;
        }
        time = time.toLowerCase();
        long totalSeconds = 0L;
        Matcher matcher = TIME_PATTERN.matcher(time);
        while (matcher.find()) {
            String unit;
            int amount = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    totalSeconds += (long)amount;
                    break;
                }
                case "m": {
                    totalSeconds += (long)amount * 60L;
                    break;
                }
                case "h": {
                    totalSeconds += (long)amount * 3600L;
                    break;
                }
                case "d": {
                    totalSeconds += (long)amount * 86400L;
                    break;
                }
                case "w": {
                    totalSeconds += (long)amount * 604800L;
                    break;
                }
                case "y": {
                    totalSeconds += (long)amount * 31536000L;
                }
            }
        }
        return totalSeconds > 0L ? totalSeconds : -1L;
    }

    public static String formatTime(long seconds) {
        long minutes;
        long hours;
        long days;
        if (seconds <= 0L) {
            return "\u041d\u0430\u0432\u0441\u0435\u0433\u0434\u0430";
        }
        StringBuilder result = new StringBuilder();
        long years = seconds / 31536000L;
        if (years > 0L) {
            result.append(years).append("\u0433 ");
            seconds %= 31536000L;
        }
        if ((days = seconds / 86400L) > 0L) {
            result.append(days).append("\u0434 ");
            seconds %= 86400L;
        }
        if ((hours = seconds / 3600L) > 0L) {
            result.append(hours).append("\u0447 ");
            seconds %= 3600L;
        }
        if ((minutes = seconds / 60L) > 0L) {
            result.append(minutes).append("\u043c ");
            seconds %= 60L;
        }
        if (seconds > 0L) {
            result.append(seconds).append("\u0441");
        }
        return result.toString().trim();
    }

    public static String formatDate(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        return sdf.format(new Date(timestamp));
    }

    public static long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }
}

